/*--------------------------------------------------------------------------*/
// Example code by Miz (CodeRage@bigfoot.com)
// Windoze 'Debugger' For Beginners ;)
// LSG-Ware - If you like/use please listen to the genius of Oliver Lieb ;)
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
#define	WIN32_LEAN_AND_MEAN			//	Eliminate some unnecessary headers
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
#include	<windows.h>
#include	<windowsx.h>
#include	<stdlib.H>
#include	"resource.h"
#include	"commctrl.h"
#include	"commdlg.h"
#include	"stdio.h"
#include	"commctrl.h"
#include	"commdlg.h"
#include	"io.h"
#include	"string.h"

#include	"Inc\File.h"
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
extern HINSTANCE	MainInstance;
STARTUPINFO			StartupInfo;
PROCESS_INFORMATION	ProcessInfo;
DEBUG_EVENT			DebugEvent;

int					FileRequestOn;
int					TokensOnly;
FILE				*LFile;

char				*MessageTokens[] = 
					{
						"WinDebug",
						"ERROR",
						"FATAL",
						"WARNING",
						"LOG",
						NULL
					};

char				FileName1[_MAX_PATH];
char				FileName2[_MAX_PATH];
char				CommandLine[128];

char				filename[_MAX_PATH];
char				drive[_MAX_DRIVE];
char				dir[_MAX_DIR];
char				fname[_MAX_FNAME];
char				ext[_MAX_EXT];
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
BOOL GetFileNameLoad(HWND hDlg, char *fileName, char *filter);
void DebugMyProcess(HWND hDlg);
void Event_OutputDebugString(DEBUG_EVENT* DebugEv, PROCESS_INFORMATION *ProcInfo);
void Event_LoadDLL(DEBUG_EVENT* DebugEv, PROCESS_INFORMATION *ProcInfo);
void Event_ExceptionDebugEvent(DEBUG_EVENT* DebugEv, PROCESS_INFORMATION *ProcInfo);
void PrintRegisters(PROCESS_INFORMATION *ProcInfo);
void MyGetFileTime(char *FileName, char *buf);
void MyGetFileDate(char *FileName, char *buf);
void MyGetFileSize(char *FileName, char *buf);
void MyGetCurrentDate(char *buf);
void MyGetCurrentTime(char *buf);
void ReadLogFile(HWND hDlg);
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void InitDialogControls(HWND hDlg)
{
int	TokenIndex;

	FileName1[0] = 0;														//Kill Target Filename
	SetDlgItemText(hDlg, IDC_FILENAME1_EDIT, &FileName1[0]);				//Kill Target Filename

	CommandLine[0] = 0;														//Kill Command Line
	SetDlgItemText(hDlg, IDC_COMMANDLINE_EDIT, &CommandLine[0]);			//Kill Command Line

	TokensOnly = FALSE;
	SendDlgItemMessage(hDlg, IDC_LOGTOKENSONLY_CHECK, BM_SETCHECK, TokensOnly, 0);

	// Fill In TOKENS
	TokenIndex = 0;
	while (MessageTokens[TokenIndex] != NULL)
		SendDlgItemMessage(hDlg, IDC_TOKENS_LIST, LB_ADDSTRING, 0, (LPARAM)MessageTokens[TokenIndex++]);
	SendDlgItemMessage(hDlg, IDC_TOKENS_LIST, LB_SETCURSEL, 0, 0);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
BOOL CALLBACK	MainDialogCallback(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
			FileRequestOn = FALSE;
			InitDialogControls(hDlg);
			return 1;

		case WM_CLOSE:
			EndDialog(hDlg, 0);
			break;

		case IDCANCEL:
			EndDialog(hDlg, 0);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDC_BROWSE1_BUTTON:
					if (GetFileNameLoad(hDlg, &FileName1[0], "*.*"))
						SetDlgItemText(hDlg, IDC_FILENAME1_EDIT, &FileName1[0]);
					break;

				case IDC_GO_BUTTON:
					//Get Filenames
					GetDlgItemText(hDlg, IDC_FILENAME1_EDIT, &FileName1[0], 120);

					_splitpath(&FileName1[0], drive, dir, fname, ext);
					strcpy(ext, "log");
					_makepath(&FileName2[0], drive, dir, fname, ext);

					//Get CommandLine
					GetDlgItemText(hDlg, IDC_COMMANDLINE_EDIT, &CommandLine[0], 120);

					DebugMyProcess(hDlg);

					if (MessageBox(0, ".LOG File Created In Target's Directory\n\nRead It Now?", "Oi!", MB_YESNO) == IDYES)
						ReadLogFile(hDlg);
					EndDialog(hDlg, 0);
					break;
		   	}
			return(1);
	}
	return(0);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void DebugMyProcess(HWND hDlg)
{
char	Buffer[256];
int		ContinueDebugging;
DWORD	ContinueStatus;

	//Here We Go!

	//Get WinDebug Only Flag
	TokensOnly = (Uint8)SendDlgItemMessage(hDlg, IDC_LOGTOKENSONLY_CHECK, BM_GETCHECK, 0, 0);

	//SetUp LogFile
 	LFile = fopen(&FileName2[0], "wt");
	if (LFile != NULL)
	{
		fprintf(LFile, "-------------------------------------------------------\n");
		fprintf(LFile, "WinDebug: Version 1.0 By Miz\n");
		fprintf(LFile, "\n");
		MyGetCurrentDate(&Buffer[0]);
		fprintf(LFile, "LogFile Start Date: %s\n", &Buffer[0]);
		MyGetCurrentTime(&Buffer[0]);
		fprintf(LFile, "LogFile Start Time: %s\n", &Buffer[0]);
		fprintf(LFile, "\n");
		fprintf(LFile, "FileName:           %s\n", &FileName1[0]);
		fprintf(LFile, "\n");
		MyGetFileDate(&FileName1[0], &Buffer[0]);
		fprintf(LFile, "FileDate:           %s\n", &Buffer[0]);
		MyGetFileTime(&FileName1[0], &Buffer[0]);
		fprintf(LFile, "FileTime:           %s\n", &Buffer[0]);
		MyGetFileSize(&FileName1[0], &Buffer[0]);
		fprintf(LFile, "Filesize:           %s\n", &Buffer[0]);
		fprintf(LFile, "-------------------------------------------------------\n\n\n");
		
		//Now Launch Our Target
		memset(&StartupInfo, 0, sizeof(STARTUPINFO));
		StartupInfo.cb = sizeof(STARTUPINFO);

		fprintf(LFile, "WinDebug: Creating Process....\n");

		sprintf(Buffer, "%s %s", &FileName1[0], &CommandLine[0]);

		if (CreateProcess(NULL,			 			// Filename
						  &Buffer[0],				// cmd line
						  NULL,						// security attr
						  NULL,						// thread attr
						  FALSE,				  	// inherit attr
						  DEBUG_ONLY_THIS_PROCESS, 	// how
						  NULL,						// environment
						  NULL,						// dir
						  &StartupInfo,				// start info
						  &ProcessInfo) )		  	// process info
		{
			fprintf(LFile, "WinDebug: Process Created Successfully....\n\n");
			ContinueDebugging = TRUE;
			
			while (ContinueDebugging)
			{
				if (WaitForDebugEvent(&DebugEvent, INFINITE))
				{
					switch (DebugEvent.dwDebugEventCode)
					{
						case CREATE_PROCESS_DEBUG_EVENT:
							ContinueStatus = DBG_CONTINUE;
							break;		

						case EXIT_PROCESS_DEBUG_EVENT:
							ContinueStatus = DBG_CONTINUE;
							ContinueDebugging = FALSE;
							break;

						case EXCEPTION_DEBUG_EVENT:
							switch (DebugEvent.u.Exception.ExceptionRecord.ExceptionCode)
							{
								case EXCEPTION_BREAKPOINT:
									ContinueStatus = DBG_CONTINUE;
									break;
								default:
									ContinueStatus = DBG_EXCEPTION_NOT_HANDLED;
									break;
							}
							Event_ExceptionDebugEvent(&DebugEvent, &ProcessInfo);
							break;

						case LOAD_DLL_DEBUG_EVENT:
							Event_LoadDLL(&DebugEvent, &ProcessInfo);
							ContinueStatus = DBG_CONTINUE;
							break;

						case OUTPUT_DEBUG_STRING_EVENT:
							Event_OutputDebugString(&DebugEvent, &ProcessInfo);
							ContinueStatus = DBG_CONTINUE;
							break;

						default:
							ContinueStatus = DBG_CONTINUE;
							break;

					}
					ContinueDebugEvent(DebugEvent.dwProcessId, DebugEvent.dwThreadId, ContinueStatus);
				}
			}
	
			CloseHandle(ProcessInfo.hProcess);
			CloseHandle(ProcessInfo.hThread);
		}
		else 
		{
			MessageBox(0, "Load Error", "Error", MB_OK);
		}
		
		fprintf(LFile, "\n");
		fprintf(LFile, "-------------------------------------------------------\n");
		MyGetCurrentTime(&Buffer[0]);
		fprintf(LFile, "LogFile End Time:   %s\n", &Buffer[0]);
		fprintf(LFile, "\n");
		fprintf(LFile, "LogFile Closed\n");
		fprintf(LFile, "-------------------------------------------------------\n");
		fprintf(LFile, "\n");
		fclose(LFile);
	}
	else
	{
		MessageBox(0, "Couldn't Create Logfile", "Error", MB_OK);
	}
}	
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void Event_OutputDebugString(DEBUG_EVENT* DebugEv, PROCESS_INFORMATION *ProcInfo)
{
OUTPUT_DEBUG_STRING_INFO	*pI;
void						*aBuff;
char						*CharBuff;
DWORD						dRead;
int							Length;
unsigned char 				SavedChar;
int							TokenIndex;
int							TokenLen;
int							Match;
	
	pI     = &DebugEv->u.DebugString;
	Length = pI->nDebugStringLength;
	aBuff  = malloc(Length + 32);

	if (aBuff)
	{
		if (ReadProcessMemory(ProcInfo->hProcess, pI->lpDebugStringData, aBuff, pI->nDebugStringLength, &dRead) == TRUE)
		{
			if (pI->fUnicode == 0)
			{
				CharBuff = (char *)aBuff;
				CharBuff[dRead] = 0;

				if (TokensOnly == TRUE)
				{
					TokenIndex = 0;
					while (MessageTokens[TokenIndex] != NULL)
					{
						TokenLen           = strlen(MessageTokens[TokenIndex]);
						SavedChar          = CharBuff[TokenLen];
						CharBuff[TokenLen] = 0;
						Match              = strcmp(&CharBuff[0], MessageTokens[TokenIndex++]);
						CharBuff[TokenLen] = SavedChar;

						if (Match == 0)
							fprintf(LFile, CharBuff);
					}
				}
				else
				{
					fprintf(LFile, CharBuff);
				}
			}
		}
		free(aBuff);
	}
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void Event_LoadDLL(DEBUG_EVENT* DebugEv, PROCESS_INFORMATION *ProcInfo)
{
LOAD_DLL_DEBUG_INFO			*pI;
void						*Base;
char						*CharBuff;
char						Buffer[128];
	
	pI       = &DebugEv->u.LoadDll;
	CharBuff = (char *) (*(long *)pI->lpImageName);
	Base     = pI->lpBaseOfDll;
	fprintf(LFile, "Loading DLL Name - '%s'\n", CharBuff);
	fprintf(LFile, "            Base - 0x%08X\n", Base);
	MyGetFileDate(CharBuff, &Buffer[0]);
	fprintf(LFile, "            Date - %s\n", &Buffer[0]);
	MyGetFileTime(CharBuff, &Buffer[0]);
	fprintf(LFile, "            Time - %s\n", &Buffer[0]);
	MyGetFileSize(CharBuff, &Buffer[0]);
	fprintf(LFile, "            Size - %s\n", &Buffer[0]);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void Event_ExceptionDebugEvent(DEBUG_EVENT* DebugEv, PROCESS_INFORMATION *ProcInfo)
{
CONTEXT					Context;
 
	//Get Eip Of Exception
	Context.ContextFlags = CONTEXT_FULL | CONTEXT_SEGMENTS;
	GetThreadContext(ProcInfo->hThread, &Context);

	fprintf(LFile, "\n");
	fprintf(LFile, "-===================================================================-\n");
	fprintf(LFile, "....EXCEPTION....\n\n");
	fprintf(LFile, "  Type: ");
   
	switch (DebugEv->u.Exception.ExceptionRecord.ExceptionCode)
	{ 
		//-- Standard exceptions 
		case EXCEPTION_ACCESS_VIOLATION: 
			fprintf(LFile, "ACCESS VIOLATION\n");
	        break;
 
		case EXCEPTION_DATATYPE_MISALIGNMENT: 
			fprintf(LFile, "DATATYPE MISALIGNMENT\n");
	        break;
 
		case EXCEPTION_BREAKPOINT:
			fprintf(LFile, "BREAKPOINT\n");
	        break; 
 
		case EXCEPTION_SINGLE_STEP:
			fprintf(LFile, "SINGLE STEP\n");
	        break; 
 
		case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
			fprintf(LFile, "ARRAY BOUND EXCEEDED\n");
	        break; 
 
		case EXCEPTION_FLT_DENORMAL_OPERAND:
			fprintf(LFile, "FLOATING POINT DENORMAL OPERAND\n");
	        break; 
 
		case EXCEPTION_FLT_DIVIDE_BY_ZERO:
			fprintf(LFile, "FLOATING POINT DIVIDE BY ZERO\n");
	        break; 
 
		case EXCEPTION_FLT_INEXACT_RESULT:
			fprintf(LFile, "FLOATING POINT INEXACT RESULT\n");
	        break; 
 
		case EXCEPTION_FLT_INVALID_OPERATION:
			fprintf(LFile, "FLOATING POINT INVALID OPERATION\n");
	        break; 
 
		case EXCEPTION_FLT_OVERFLOW:
			fprintf(LFile, "FLOATING POINT OVERFLOW\n");
	        break; 
 
		case EXCEPTION_FLT_STACK_CHECK:
			fprintf(LFile, "FLOATING POINT STACK CHECK\n");
	        break; 
 
		case EXCEPTION_FLT_UNDERFLOW:
			fprintf(LFile, "FLOATING POINT UNDERFLOW\n");
	        break; 
 
		case EXCEPTION_INT_DIVIDE_BY_ZERO:
			fprintf(LFile, "INTEGER DIVIDE BY ZERO\n");
	        break; 
 
		case EXCEPTION_INT_OVERFLOW:
			fprintf(LFile, "INTEGER OVERFLOW\n");
	        break; 
 
		case EXCEPTION_PRIV_INSTRUCTION:
			fprintf(LFile, "PRIVILEGED INSTRUCTION\n");
	        break; 

		case EXCEPTION_IN_PAGE_ERROR:
			fprintf(LFile, "IN PAGE ERROR\n");
	        break; 
 
		//-- Debug exceptions 
		case DBG_TERMINATE_THREAD:
			fprintf(LFile, "Debug Exception - TERMINATE THREAD\n");
	        break; 
 
		case DBG_TERMINATE_PROCESS:
			fprintf(LFile, "Debug Exception - TERMINATE PROCESS\n");
	        break; 
 
		case DBG_CONTROL_C:
			fprintf(LFile, "Debug Exception - CONTROL+C\n");
	        break; 
 
		case DBG_CONTROL_BREAK:
			fprintf(LFile, "Debug Exception - CONTROL+BREAK\n");
	        break; 
 
		//-- RPC exceptions (some)
		case RPC_S_UNKNOWN_IF:
			fprintf(LFile, "RPC Exception - UNKNOWN INTERFACE\n");
	        break; 
 
		case RPC_S_SERVER_UNAVAILABLE:
			fprintf(LFile, "RPC Exception - SERVER UNAVAILABLE\n");
	        break; 
 
		default:
			fprintf(LFile, "UNKNOWN TYPE (0x%08X)\n", DebugEv->u.Exception.ExceptionRecord.ExceptionCode);
	        break; 
    } 

	fprintf(LFile, "  Addr: 0x%08X\n", Context.Eip);
	if (DebugEv->u.Exception.dwFirstChance != 0)
		fprintf(LFile, "  First Chance\n");
	else
		fprintf(LFile, "  Second Chance\n");
	
	PrintRegisters(ProcInfo);

	fprintf(LFile, "-===================================================================-\n");
	fprintf(LFile, "\n");
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void PrintRegisters(PROCESS_INFORMATION *ProcInfo)
{
CONTEXT Context;
 
	Context.ContextFlags = CONTEXT_FULL | CONTEXT_SEGMENTS;
	if (GetThreadContext(ProcInfo->hThread, &Context))
	{
		fprintf(LFile, "\n");
		fprintf(LFile, "   EAX: 0x%08x  EBX: 0x%08x  ECX: 0x%08x  EDX: 0x%08x\n", Context.Eax, Context.Ebx, Context.Ecx, Context.Edx);
		fprintf(LFile, "   ESI: 0x%08x  EDI: 0x%08x\n", Context.Esi, Context.Edi);
		fprintf(LFile, "   EBP: 0x%08x  ESP: 0x%08x\n", Context.Ebp, Context.Esp);
		fprintf(LFile, "\n");
		fprintf(LFile, "   EIP: 0x%08x\n", Context.Eip);
		fprintf(LFile, "    CS: 0x%04x\n", Context.SegCs);
		fprintf(LFile, "    DS: 0x%04x\n", Context.SegDs);
		fprintf(LFile, "    SS: 0x%04x\n", Context.SegSs);
		fprintf(LFile, "    ES: 0x%04x      FS: 0x%04x       GS: 0x%04x\n", Context.SegEs, Context.SegFs,Context.SegGs);
		fprintf(LFile, " FLAGS: 0x%04x\n", Context.EFlags);
	}
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
BOOL GetFileNameLoad(HWND hDlg, char *fileName, char *filter)
{
OPENFILENAME	ofn;
char			strfilter[128];
int				i;
int				c;
int				len;
int				returnval;

	FileRequestOn = TRUE;

	len = strlen(filter);
	c   = 0;
	for (i=0; i<len; i++)
		strfilter[c++] = filter[i];
	strfilter[c++] = 0;
	for (i=0; i<len; i++)
		strfilter[c++] = filter[i];
	strfilter[c++] = 0;
	strfilter[c++] = 0;

	memset(&ofn, 0, sizeof(OPENFILENAME));

	fileName[0]           = 0;
	ofn.lStructSize		  =	sizeof(OPENFILENAME);
	ofn.hwndOwner	  	  = hDlg;
	ofn.hInstance		  = MainInstance;
	ofn.lpstrFilter		  = strfilter;
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter	  = 0;
	ofn.nFilterIndex	  = 0;
	ofn.lpstrFile	  	  = fileName;
	ofn.nMaxFile		  = _MAX_PATH;
	ofn.lpstrFileTitle	  = NULL;
	ofn.nMaxFileTitle	  = 0;
	ofn.lpstrInitialDir   = ".//";
	ofn.lpstrTitle		  = "Select File";
	ofn.lpstrDefExt		  = "*";
	ofn.Flags		  	  = OFN_FILEMUSTEXIST | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON | OFN_EXPLORER | OFN_HIDEREADONLY;
	returnval             = GetOpenFileName(&ofn);
	FileRequestOn         = FALSE;
	return(returnval);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void MyGetFileTime(char *FileName, char *buf)
{
int			hFile;
OFSTRUCT	os; 
FILETIME	ftCreate, ftLastAccess, ftLastWrite, ftLocal;
SYSTEMTIME	st;

    hFile = OpenFile(FileName, &os, OF_READ|OF_SHARE_DENY_NONE);

	// Get the file time (in UTC) and convert to local time.
	GetFileTime((HANDLE) hFile, &ftCreate, &ftLastAccess, &ftLastWrite);
	FileTimeToLocalFileTime(&ftLastWrite, &ftLocal);
	FileTimeToSystemTime(&ftLocal, &st);
	GetTimeFormat(LOCALE_USER_DEFAULT, 0, &st, NULL, buf, 128);

    _lclose(hFile); 
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void MyGetFileDate(char *FileName, char *buf)
{
int			hFile;
OFSTRUCT	os; 
FILETIME	ftCreate, ftLastAccess, ftLastWrite, ftLocal;
SYSTEMTIME	st;

    hFile = OpenFile(FileName, &os, OF_READ|OF_SHARE_DENY_NONE);

	// Get the file time (in UTC) and convert to local time.
	GetFileTime((HANDLE) hFile, &ftCreate, &ftLastAccess, &ftLastWrite);
	FileTimeToLocalFileTime(&ftLastWrite, &ftLocal);
	FileTimeToSystemTime(&ftLocal, &st);
	GetDateFormat(LOCALE_USER_DEFAULT, 0, &st, NULL, buf, 128);

    _lclose(hFile); 
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void MyGetFileSize(char *FileName, char *buf)
{
int				hFile;
OFSTRUCT		os; 
unsigned int	FileSize;

    hFile = OpenFile(FileName, &os, OF_READ|OF_SHARE_DENY_NONE);

	FileSize = GetFileSize((HANDLE) hFile, NULL);
	sprintf(buf, "%u", FileSize);

    _lclose(hFile);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void MyGetCurrentDate(char *buf)
{
SYSTEMTIME	st;

	// Get the file time (in UTC) and convert to local time.
	GetSystemTime(&st);
	GetDateFormat(LOCALE_USER_DEFAULT, 0, &st, NULL, buf, 128);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void MyGetCurrentTime(char *buf)
{
SYSTEMTIME	st;

	// Get the file time (in UTC) and convert to local time.
	GetSystemTime(&st);
	GetTimeFormat(LOCALE_USER_DEFAULT, 0, &st, NULL, buf, 128);
}
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
void ReadLogFile(HWND hDlg)
{
char	Buffer[256];

	//Now Launch Our Target
	memset(&StartupInfo, 0, sizeof(STARTUPINFO));
	StartupInfo.cb = sizeof(STARTUPINFO);

	sprintf(Buffer, "notepad.exe %s", &FileName2[0]);

	if (CreateProcess(NULL,			 			// Filename
					  &Buffer[0],				// cmd line
					  NULL,						// security attr
					  NULL,						// thread attr
					  FALSE,				  	// inherit attr
					  0,					 	// how
					  NULL,						// environment
					  NULL,						// dir
					  &StartupInfo,				// start info
					  &ProcessInfo) )		  	// process info
	{
		CloseHandle(ProcessInfo.hProcess);
		CloseHandle(ProcessInfo.hThread);
	}
	else 
	{
		MessageBox(0, "Load Notepad Error", "Error", MB_OK);
	}
}	
/*--------------------------------------------------------------------------*/

